#include "graphics.h"
#include "fstream.h"
#include "conio.h"

const int MaxVivod=20;

struct Point{
             int x,y;
	     int con[MaxVivod];
             int kol_soed;
	     };

Point Graf[MaxVivod];
int n;
int Ox=20, Oy=20, mashtab=50;

void GrafLine(int i, int j)
{
  int  x1=Graf[i].x*mashtab+Ox,
       y1=getmaxy()-Graf[i].y*mashtab-Oy,
       x2=Graf[j].x*mashtab+Ox,
       y2=getmaxy()-Graf[j].y*mashtab-Ox;

  setcolor(WHITE);
  line(x1, y1, x2,y2);
}

void GrafPoint(int i, int color)
{
  int  x1=Graf[i].x*mashtab+Ox,
       y1=getmaxy()-Graf[i].y*mashtab-Oy;

  setcolor(color);
  circle(x1, y1, 3);
  setfillstyle(1, color);
  floodfill(x1, y1, color);
 }

 int main()
 {

   fstream f;
   f.open("1.txt", ios::in);

   if(f.rdstate()==ios::badbit || f.rdstate()==ios::failbit)
   {
     cout<<"Ne najden fail s dannimi - 1.txt!\n";
     getch();
     clrscr();
     return -2;
   }
   f>>n;
   if(f.bad()!=0 || n>MaxVivod)
   {
     cout<<"Nepravilnoe kolichestvo vershin (>=0 i >"<<MaxVivod<<")\n";
     getch();
     clrscr();
     return -3;
   }
   int i, j;
   for(i=0; i<n; i++)
   {
     f>>Graf[i].x>>Graf[i].y;
     if(f.bad()!=0 || Graf[i].x<0 || Graf[i].y<0)
     {
       cout<<"ERROR: Nepravilno ukazani koordinati vershini!\n";
       getch();
       clrscr();
       return -1;
     }
     Graf[i].kol_soed=0;
     for(j=0; j<n; j++)
     {
       f>>Graf[i].con[j];
       if(f.bad()!=0 || (Graf[i].con[j]!=0 && Graf[i].con[j]!=1))
       {
	 cout<<"ERROR: Nepravilno zadani soedinenija!\n";
	 getch();
	 clrscr();
         return -1;
       }
       Graf[i].kol_soed+=Graf[i].con[j];
     }
   }

   int order[MaxVivod];
   for(i=0; i<n; i++) order[i]=i;

   for(i=0; i<n; i++)
   {
     int max=Graf[order[i]].kol_soed, N=i;

     for(j=i+1; j<n; j++)
           if(Graf[order[j]].kol_soed>max)
          {
             max=Graf[order[j]].kol_soed;
             N=j;
          }
       if(N!=i)
       {
         int tmp=order[i];
         order[i]=order[N];
         order[N]=tmp;
       }
    }

    int Head[MaxVivod];
    for(i=0; i<n; i++)
       Head[i]=1;

    for(i=0; i<n; i++)
    {
      int cur=order[i];
      if(Head[cur]!=1)
         continue;
      Head[cur]=2;
      for(j=0; j<n; j++)
          if(Graf[cur].con[j]>0)
          {
            Head[j]=0;
          }
    }
    f.close();

    cout<<"Spisok vershin, sostavlajushih pokritie grafa...\n";
    for(i=0; i<n; i++)
    {
      if(Head[i]==2)
        cout<<i+1<<" ";
    }
    cout<<"\nRisuem eto...\n";
    getch();

    int d=0, m=0;
    initgraph(&d, &m, "");
    if(graphresult()!=0)
    {
      cout<<"Nevozmozhno zapuctit graficheskij rezhim - ne najden fail EGAVGA.BGI!";
      return -5;
    }
    for(i=0; i<n; i++)
    {
      for(j=i+1; j<n; j++)
          if(Graf[i].con[j]!=0)
             GrafLine(i, j);
    }

    for(i=0; i<n; i++)
    {
      int color;
      if(Head[i]==2)
         color=RED;
      else
         color=WHITE;

      GrafPoint(i, color);
    }
    setcolor(WHITE);
    outtextxy(0,0,"Nazhmite lubuju klavishu dla vihoda...");
    getch();
    closegraph();

    int N=0;
    for(i=0; i<n; i++)
       if(Head[i]==2) N++;

    cout<<"Pokritie sostoit iz "<<N<<" vershin.\n";

    getch();
    clrscr();
    return 0;
 }

       
